//
//  ICFAssetGroupViewController.h
//  Asset Library Navigator
//
//  Created by Joe Keeley on 4/15/12.
//  Copyright (c) 2012 Explore Systems, Inc. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AssetsLibrary/AssetsLibrary.h>

@interface ICFAssetGroupViewController : UIViewController <UITableViewDataSource, UITableViewDelegate, UIImagePickerControllerDelegate, UINavigationControllerDelegate>

@property (nonatomic, strong) NSMutableArray *assetArray;
@property (nonatomic, strong) NSURL *assetGroupURL;
@property (nonatomic, strong) NSString *assetGroupName;
@property (nonatomic, strong) IBOutlet UITableView *assetTableView;
@property (nonatomic, strong) IBOutlet UIBarButtonItem *addButton;
@property (nonatomic, strong) ALAssetsLibrary *assetsLibrary;

- (IBAction)addButtonTouched:(id)sender;
- (void)image:(UIImage *) image didFinishSavingWithError: (NSError *) error contextInfo: (void *) contextInfo;
@end
